/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.potion.Effects;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;

public class Stamina
implements IStamina {
    @Nullable
    private final Player player;
    private int stamina = 0;
    private int staminaOld = 0;
    private int maxStamina = 1;
    private boolean exhausted = false;
    private int recoverCoolTime = 0;

    public Stamina(@Nullable Player player) {
        this.player = player;
        if (player != null && player.m_7578_()) {
            this.maxStamina = (Integer)ParCoolConfig.CONFIG_CLIENT.staminaMax.get();
            this.set(this.maxStamina);
        }
    }

    public Stamina() {
        this.player = null;
    }

    @Override
    public int getMaxStamina() {
        return this.maxStamina;
    }

    @Override
    public int getActualMaxStamina() {
        if (this.player == null) {
            return this.maxStamina;
        }
        Parkourability parkourability = Parkourability.get(this.player);
        if (parkourability == null) {
            return this.maxStamina;
        }
        return Math.min(this.maxStamina, parkourability.getActionInfo().getMaxStaminaLimitation());
    }

    @Override
    public void setMaxStamina(int value) {
        this.maxStamina = this.stamina;
    }

    @Override
    public int get() {
        return this.stamina;
    }

    @Override
    public int getOldValue() {
        return this.staminaOld;
    }

    @Override
    public void consume(int value) {
        if (this.player == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get(this.player);
        if (parkourability == null) {
            return;
        }
        if (this.exhausted || ((Boolean)ParCoolConfig.CONFIG_CLIENT.infiniteStamina.get()).booleanValue() && parkourability.getActionInfo().isInfiniteStaminaPermitted() || this.player.m_21023_(Effects.INEXHAUSTIBLE)) {
            return;
        }
        if (((Boolean)ParCoolConfig.CONFIG_CLIENT.useHungerBarInsteadOfStamina.get()).booleanValue()) {
            this.player.m_36399_((float)value / 1000.0f);
            return;
        }
        this.recoverCoolTime = 30;
        this.set(this.stamina - value);
        if (this.stamina == 0) {
            this.exhausted = true;
        }
    }

    @Override
    public void recover(int value) {
        this.set(this.stamina + value);
        if (this.stamina == this.getActualMaxStamina()) {
            this.exhausted = false;
        }
    }

    @Override
    public boolean isExhausted() {
        return this.exhausted;
    }

    @Override
    public void setExhaustion(boolean value) {
        this.exhausted = value;
    }

    @Override
    public void tick() {
        this.staminaOld = this.stamina;
        if (this.recoverCoolTime > 0) {
            --this.recoverCoolTime;
        }
        if (this.recoverCoolTime <= 0) {
            if (this.player == null) {
                return;
            }
            Parkourability parkourability = Parkourability.get(this.player);
            if (parkourability == null) {
                return;
            }
            this.recover(Math.min((Integer)ParCoolConfig.CONFIG_CLIENT.staminaRecovery.get(), parkourability.getActionInfo().getMaxStaminaRecoveryLimitation()));
        }
    }

    @Override
    public void set(int value) {
        this.stamina = Math.min(value, this.getActualMaxStamina());
        if (this.stamina <= 0) {
            this.stamina = 0;
        }
    }
}

